#include "TCPIPConfig.h"

#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/StackTsk.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "lcd.h"
#include "node.h"
#include "dprs_symbol.h"
#include "crc.h"

#include <stdlib.h>
#include <ctype.h>

#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "usb_config.h"
#include "USB/usb.h"
#include "USB/usb_host_generic.h"
#include "../include/USB/timer.h"
#include "../USB/usb_host_local.h"
#include "MDD File System/FSIO.h"
#include "MDD File System/FSDefs.h"

enum
	{
		REFSOLVE_HOME = 0,
		REFSOLVE_NAME_RESOLVE,
		REFSOLVE_OBTAIN,
	} RefSolveState = REFSOLVE_HOME;

BYTE	RefDomainName[110];
static	DWORD	DnsTimer;

extern	BOOL	ReqRefDomainName;


static	void	RefSolved(void)
{
	static	IP_ADDR	ServerIP;

	switch(RefSolveState)
	{
		case REFSOLVE_HOME:
			// Obtain ownership of the DNS resolution module
			if(!DNSBeginUsage()) break;

			DNSResolve(RefDomainName, DNS_TYPE_A);
			
			DnsTimer = TickGet();
			RefSolveState++;
			break;

		case REFSOLVE_NAME_RESOLVE:
			// Wait for the DNS server to return the requested IP address
			if(!DNSIsResolved(&ServerIP))
			{
				// Timeout after 6 seconds of unsuccessful DNS resolution
				if(TickGet() - DnsTimer > 12*TICK_SECOND)
				{
					RefSolveState = REFSOLVE_HOME;
					DNSEndUsage();
				}
				break;
			}

			// Release the DNS module, we no longer need it
			if(!DNSEndUsage())
			{
				// An invalid IP address was returned from the DNS 
				// server.  Quit and fail permanantly if host is not valid.
				RefSolveState++;
				ServerIP.Val = 0;
				break;
			}

			RefSolveState++;
			// No need to break here

		case REFSOLVE_OBTAIN:
			memset (RefDomainName, 0x00, 20);
			sprintf ((char *)RefDomainName, "%-d.%-d.%-d.%-d",ServerIP.v[0], ServerIP.v[1], ServerIP.v[2], ServerIP.v[3]);
			RefSolveState = REFSOLVE_HOME;
			ReqRefDomainName = FALSE;
			break;			
	}
}
